#!/bin/sh

# arg 1:thread id
# arg 2:thread name
# arg 3:current monitor time

MAX_LOG_NO=5

if [ $# -ne 3 ]; then
    echo "Incorrect arguments."
    exit 1
fi

if [ ! -d /flash/sw_wtd_log ]; then
        mkdir /flash/sw_wtd_log
fi

# Due to sw_wtd_global_log.sh already update( + 1) the counter
# We decrease teh logno to let the log information in the same file.
if [ -f /flash/sw_wtd_log/next_log_no ]; then
        logno=`cat /flash/sw_wtd_log/next_log_no`
        if [ ${logno} = 0 ];then
            let logno=${MAX_LOG_NO}-1
        else
            let logno=${logno}-1
        fi

else
        logno=0
fi

# generate software watchdog log filename
LOG_FILE="/flash/sw_wtd_log/sw_wtd_log"${logno}".txt"
echo "==================================================" >> ${LOG_FILE}
echo "Monitored thread id:$1 thread name:$2 current monitor time:$3" >> ${LOG_FILE}

# Check whether the thread id exists
if [ ! -d /proc/$1 ];then
echo "/proc/$1 no such directory(Thread id $1 not exists)" >> ${LOG_FILE}
else
echo "" >> ${LOG_FILE}
# Due to the special implementation in /proc/$1/ustack, the output by printk is
# not able to redirect. So a quick way to capture the output is to redirect the
# content of dmesg.
cat /proc/$1/ustack
dmesg | tail -n 40 >> ${LOG_FILE}
echo "" >> ${LOG_FILE}

# Too much content in /proc/$1/maps, do not dump.
#echo "cat /proc/$1/maps" >> ${LOG_FILE}
#cat /proc/$1/maps >> ${LOG_FILE}
#echo "" >> ${LOG_FILE}

# dump wchan
echo "#cat /proc/$1/wchan" >> ${LOG_FILE}
cat /proc/$1/wchan >> ${LOG_FILE}
echo "" >> ${LOG_FILE}

# dump status
echo "#cat /proc/$1/status" >> ${LOG_FILE}
cat /proc/$1/status >> ${LOG_FILE}
echo "" >> ${LOG_FILE}
fi

exit 0

